using System;

namespace Nocna_Vožnja
{
    public class Naselje
    {
        public int id { get; set; }
        public bool[] povezanost { get; set; }

        public Naselje(int id, int n)
        {
            this.id = id;
            povezanost = new bool[n + 1];
        }
    }

    internal class Program
    {
        static int[] Index(int[] p, int n)
        {
            int[] index = new int[n + 1];
            for (int i = 1; i <= n; i++)
            {
                int j = 0;
                while (true)
                {
                    if (p[j] == i)
                    {
                        index[i] = j;
                        break;
                    }
                    j++;
                }
            }
            return index;
        }

        static void Swap(int[] p, int[] index, int a, int b)
        {
            p[index[a]] = b;
            p[index[b]] = a;
        }

        static void Zamena(Naselje[] n, int a, int b)
        {
            Naselje temp = n[a];
            n[a] = n[b];
            n[b] = temp;
        }

        static bool Rastojanje_recursion(Naselje[] n, int i, int x, ref int rastojanje, int preth, int[] index)
        {
            if (!n[i].povezanost[x])
            {
                for (int j = 1; j <= n.Length; j++)
                {
                    if (n[i].povezanost[j] == true && index[j] != preth)
                    {
                        bool put = Rastojanje_recursion(n, index[j], x, ref rastojanje, i, index);
                        if (put)
                        {
                            rastojanje++;
                            return put;
                        }
                    }
                }
            }
            else
            {
                return true;
            }
            return false;
        }

        static int Rastojanje(Naselje[] n, int l, int r, int x, int[] index)
        {
            int rastojanje = 1, r_max = 0;
            for (int i = l ; i <= r; i++)
            {
                rastojanje = 1;
                Rastojanje_recursion(n, i, x, ref rastojanje, i, index);
                if (rastojanje > r_max) {
                    r_max = rastojanje;
                }
            }
            return r_max;
        }

        static void Main(string[] args)
        {
            int n=Convert.ToInt32(Console.ReadLine());
            Naselje[] naselja = new Naselje[n];
            int[] p = new int[n];
            string[] order = Console.ReadLine().Split(' ');
            for(int i = 0; i < n; i++)
            {
                p[i] = Convert.ToInt32(order[i]);
                naselja[i] = new Naselje(p[i], n);
            }
            int[] index = Index(p, n);
            for (int i = 0; i < n - 1; i++)
            {
                string[] povezanost = Console.ReadLine().Split(' ');
                int u = Convert.ToInt32(povezanost[0]);
                int v = Convert.ToInt32(povezanost[1]);
                naselja[index[u]].povezanost[v] = true;
                naselja[index[v]].povezanost[u] = true;
            }
            int q = Convert.ToInt32(Console.ReadLine());
            int[] rastojanja = new int[n];
            int r_lenght = 0;
            for(int i = 0; i < q; i++)
            {
                string[] dogadjaji = Console.ReadLine().Split(' ');
                if (dogadjaji[0] == "1") {
                    Zamena(naselja, index[Convert.ToInt32(dogadjaji[1])], index[Convert.ToInt32(dogadjaji[2])]);
                    Swap(p, index, Convert.ToInt32(dogadjaji[1]), Convert.ToInt32(dogadjaji[2]));
                    index = Index(p, n);
                } 
                else {
                    rastojanja[r_lenght] = Rastojanje(naselja, Convert.ToInt32(dogadjaji[1]) - 1, Convert.ToInt32(dogadjaji[2]) - 1, Convert.ToInt32(dogadjaji[3]), index);
                    r_lenght++;
                } 
            }
            for(int i = 0; i < r_lenght; i++)
            {
                Console.WriteLine(rastojanja[i]);
            }
        }
    }
}